/* ArpConsole.cpp
 */
#include "ArpConsole.h"

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include "ArpKernel/ArpDebug.h"
#include "AmPublic/AmFilterConfigLayout.h"

//#define PRINT_SECTION_INFO		(1)

ArpMOD();

static AmStaticResources gRes;

/*****************************************************************************
 * ARP-CONSOLE-FILTER
 *****************************************************************************/
ArpConsoleFilter::ArpConsoleFilter(ArpConsoleFilterAddOn* addon,
								   AmFilterHolderI* holder,
								   const BMessage* config)
	: AmFilterI(addon),
	  mDevice(NULL),
	  mAddOn(addon), mHolder(holder)
{
	//ArpRef<AmBank> bank = new AmBank(128);
	//mDevice = new AmDevice("Debug", bank);
	if (config) PutConfiguration(config);
}

ArpConsoleFilter::~ArpConsoleFilter()
{
}

AmEvent* ArpConsoleFilter::StartSection(AmTime firstTime, AmTime lastTime,
										const am_filter_params* params)
{
#ifdef PRINT_SECTION_INFO
	printf("Filter %s: Start %Ld to %Ld\n", Label(), firstTime, lastTime);
		print_params(params);
#endif
	return NULL;
}

AmEvent* ArpConsoleFilter::FinishSection(AmTime firstTime, AmTime lastTime,
										 const am_filter_params* params)
{
#ifdef PRINT_SECTION_INFO
	printf("Filter %s: Finish %Ld to %Ld\n", Label(), firstTime, lastTime);
		print_params(params);
#endif
	return NULL;
}

void ArpConsoleFilter::Stop(uint32 context)
{
#ifdef PRINT_SECTION_INFO
	printf("Filter %s: Stop\n", Label());
#endif
}

AmEvent* ArpConsoleFilter::HandleEvent(AmEvent* event, const am_filter_params* params)
{
	if( !event ) printf("NULL event!\n");
	else {
		printf("Filter %s: ", Label().String() );
		event->Print();
		print_params(params);
		if (mHolder) event->SetNextFilter(mHolder->FirstConnection() );
	}
	
	return event;
}

#define PREFIX "\t -> "

void ArpConsoleFilter::print_params(const am_filter_params* params) const
{
	if (!params) {
		printf(PREFIX "NO PARAMS.\n");
		return;
	}
	
	if (params->cur_tempo || params->cur_signature) {
		if (params && params->cur_tempo) {
			if (params->cur_tempo->NextEvent() != NULL) {
				printf(PREFIX "Tempos:\n"); params->cur_tempo->PrintChain(0, PREFIX);
			} else {
				printf(PREFIX "Tempo: "); params->cur_tempo->Print();
			}
		} else {
			printf(PREFIX "NO TEMPO.\n");
		}
		if (params && params->cur_signature) {
			if (params->cur_signature->NextEvent() != NULL) {
				printf(PREFIX "Signatures:\n"); params->cur_signature->PrintChain(0, PREFIX);
			} else {
				printf(PREFIX "Signature: "); params->cur_signature->Print();
			}
		} else {
			printf(PREFIX "NO SIGNATURE.\n");
		}
	} else {
		printf(PREFIX "NO TEMPO OR SIGNATURE.\n");
	}
}

status_t ArpConsoleFilter::GetConfiguration(BMessage* values) const
{
	return AmFilterI::GetConfiguration(values);
}

status_t ArpConsoleFilter::PutConfiguration(const BMessage* values)
{
	return AmFilterI::PutConfiguration(values);
}

/*****************************************************************************
 * ARP-CONSOLE-FILTER-ADD-ON
 *****************************************************************************/
void ArpConsoleFilterAddOn::LongDescription(BString& name, BString& str) const
{
	AmFilterAddOn::LongDescription(name, str);
	str << "<P>I print in the terminal every MIDI event I receive. I am useful
	for debugging any filters you've written, so you can see the output
	they are providing.  In order for this filter to work, Sequitur must be
	launched from a command line.</P>";
}

void ArpConsoleFilterAddOn::GetVersion(int32* major, int32* minor) const
{
	*major = 1;
	*minor = 0;
}

BBitmap* ArpConsoleFilterAddOn::Image(BPoint requestedSize) const
{
	const BBitmap* bm = gRes.Resources().FindBitmap("Class Icon");
	if (bm) return new BBitmap(bm);
	return NULL;
}

extern "C" _EXPORT AmFilterAddOn* make_nth_filter(int32 n, image_id /*you*/,
												  const void* cookie, uint32 /*flags*/, ...)
{
	if (n == 0) return new ArpConsoleFilterAddOn(cookie);
	return NULL;
}
