#include "EmuProteus2000.h"

static const char*	SYSEX_MIX_OUTPUT		= "Mix";
static const char*	SYSEX_FX_CTRL_CHANNEL	= "FX Control";
static const char*	SYSEX_FX_BYPASS			= "FX Mode";
static const char*	SYSEX_FX_A				= "FX A";
static const char*	SYSEX_FX_A_DCY			= "FX A Decay";
static const char*	SYSEX_FX_A_HFDAMP		= "FX A HF Damp";
static const char*	SYSEX_FX_B_INTO_A		= "FX B -> A";
static const char*	SYSEX_FX_A_SEND_1		= "FX A Send 1";
static const char*	SYSEX_FX_A_SEND_2		= "FX A Send 2";
static const char*	SYSEX_FX_A_SEND_3		= "FX A Send 3";
static const char*	SYSEX_FX_A_SEND_4		= "FX A Send 4";
static const char*	SYSEX_FX_B				= "FX B";
static const char*	SYSEX_FX_B_FEEDBACK		= "FX B Feedback";
static const char*	SYSEX_FX_B_LFO			= "FX B LFO";
static const char*	SYSEX_FX_B_DELAY		= "FX B Delay";
static const char*	SYSEX_FX_B_SEND_1		= "FX B Send 1";
static const char*	SYSEX_FX_B_SEND_2		= "FX B Send 2";
static const char*	SYSEX_FX_B_SEND_3		= "FX B Send 3";
static const char*	SYSEX_FX_B_SEND_4		= "FX B Send 4";

/*************************************************************************
 * EMU-PROTEUS-2000
 *************************************************************************/
EmuProteus2000::EmuProteus2000(BMessage* device, const entry_ref* ref)
		: inherited(device, ref)
{
	RemoveSysExCommands();

	/* MULTIMODE (Channel specific). */
	AddP2KMultiParamEdit(BString(SYSEX_MIX_OUTPUT),	0x05, 0x01, -1, 3, -1);

	/* MASTER. */
	AddP2KParamEdit(BString(SYSEX_FX_BYPASS),		0x02, 0x02, 0, 1, 1);
	AddP2KParamEdit(BString(SYSEX_FX_CTRL_CHANNEL),	0x0C, 0x01, -1, 31, -1);
	AddP2KParamEdit(BString(SYSEX_FX_A),			0x01, 0x04, 1, 44, 1);
	AddP2KParamEdit(BString(SYSEX_FX_A_DCY),		0x02, 0x04, 0, 90, 30);
	AddP2KParamEdit(BString(SYSEX_FX_A_HFDAMP),		0x03, 0x04, 0, 127, 20);
	AddP2KParamEdit(BString(SYSEX_FX_B_INTO_A),		0x04, 0x04, 0, 127, 0);
	AddP2KParamEdit(BString(SYSEX_FX_A_SEND_1),		0x05, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_A_SEND_2),		0x06, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_A_SEND_3),		0x07, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_A_SEND_4),		0x0F, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_B),			0x08, 0x04, 1, 32, 1);
	AddP2KParamEdit(BString(SYSEX_FX_B_FEEDBACK),	0x09, 0x04, 0, 127, 1);
	AddP2KParamEdit(BString(SYSEX_FX_B_LFO),		0x0A, 0x04, 0, 127, 1);
	AddP2KParamEdit(BString(SYSEX_FX_B_DELAY),		0x0B, 0x04, 0, 127, 1);
	AddP2KParamEdit(BString(SYSEX_FX_B_SEND_1),		0x0C, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_B_SEND_2),		0x0D, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_B_SEND_3),		0x0E, 0x04, 0, 100, 0);
	AddP2KParamEdit(BString(SYSEX_FX_B_SEND_4),		0x10, 0x04, 0, 100, 0);
}

static void fill_value_labels(vector<BString>& v, const BString& key)
{
	v.resize(0);
	if (key == SYSEX_MIX_OUTPUT) {
		v.push_back("Preset"); v.push_back("Send 1"); v.push_back("Send 2"); v.push_back("Send 3"); v.push_back("Send 4");
	} else if (key == SYSEX_FX_CTRL_CHANNEL) {
		v.push_back("Master"); v.push_back("1A"); v.push_back("2A"); v.push_back("3A"); v.push_back("4A"); v.push_back("5A"); v.push_back("6A"); v.push_back("7A"); v.push_back("8A");
		v.push_back("9A"); v.push_back("10A"); v.push_back("11A"); v.push_back("12A"); v.push_back("13A"); v.push_back("14A"); v.push_back("15A"); v.push_back("16A");
		v.push_back("1B"); v.push_back("2B"); v.push_back("3B"); v.push_back("4B"); v.push_back("5B"); v.push_back("6B"); v.push_back("7B"); v.push_back("8B");
		v.push_back("9B"); v.push_back("10B"); v.push_back("11B"); v.push_back("12B"); v.push_back("13B"); v.push_back("14B"); v.push_back("15B"); v.push_back("16B");
	} else if (key == SYSEX_FX_BYPASS) {
		v.push_back("Off"); v.push_back("On");
	} else if (key == SYSEX_FX_A) {
		v.push_back("Room 1"); v.push_back("Room 2"); v.push_back("Room 3"); v.push_back("Hall 1"); v.push_back("Hall 2"); v.push_back("Plate");
		v.push_back("Delay"); v.push_back("Panning Delay"); v.push_back("Multitap 1"); v.push_back("Multitap Pan"); v.push_back("3 Tap"); v.push_back("3 Tap Pan");
		v.push_back("Soft Room"); v.push_back("Warm Room"); v.push_back("Perfect Room"); v.push_back("Tiled Room"); v.push_back("Hard Plate"); v.push_back("Warm Hall");
		v.push_back("Spacious Hall"); v.push_back("Bright Hall"); v.push_back("Bright Hall Pan"); v.push_back("Bright Plate"); v.push_back("BBall Court"); v.push_back("Gymnasium");
		v.push_back("Cavern"); v.push_back("Concert 9"); v.push_back("Concert 10 Pan"); v.push_back("Reverse Gate"); v.push_back("Gate 2"); v.push_back("Gate Pan"); v.push_back("Concert 11");
		v.push_back("Medium Concert"); v.push_back("Large Concert"); v.push_back("Lage Concert Pan"); v.push_back("Canyon"); v.push_back("DelayVerb 1"); v.push_back("DelayVerb 2"); v.push_back("DelayVerb 3");
		v.push_back("DelayVerb 4 Pan"); v.push_back("DelayVerb 5 Pan"); v.push_back("DelayVerb 6"); v.push_back("DelayVerb 7"); v.push_back("DelayVerb 8"); v.push_back("DelayVerb 9");
	} else if (key == SYSEX_FX_B) {
		v.push_back("Chorus 1"); v.push_back("Chorus 2"); v.push_back("Chorus 3"); v.push_back("Chorus 4"); v.push_back("Chorus 5"); v.push_back("Doubling"); v.push_back("Slapback"); v.push_back("Flange 1");
		v.push_back("Flange 2"); v.push_back("Flange 3"); v.push_back("Flange 4"); v.push_back("Flange 5"); v.push_back("Flange 6"); v.push_back("Flange 7"); v.push_back("Big Chorus"); v.push_back("Symphonic");
		v.push_back("Ensemble"); v.push_back("Delay"); v.push_back("Delay Stereo"); v.push_back("Delay Stereo 2"); v.push_back("Panning Delay"); v.push_back("Delay Chorus"); v.push_back("Pan Dly Chrs 1");
		v.push_back("Pan Dly Chrs 2"); v.push_back("DualTap 1/3"); v.push_back("DualTap 1/4"); v.push_back("Vibrato"); v.push_back("Distortion 1"); v.push_back("Distortion 2"); v.push_back("Distorted Flange");
		v.push_back("Distorted Chorus"); v.push_back("Distorted Double");
	}
}

status_t EmuProteus2000::AddP2KParamEdit(	const BString& key, uint8 clsb, uint8 cmsb,
											int32 valueMin, int32 valueMax, int32 initValue)
{
	uint8					data[12];
	data[0] = 0xF0; data[1] = 0x18; data[2] = 0x0F; data[3] = 0x00;
	data[4] = 0x55;
	data[5] = 0x01;					// Parameter edit
	data[6] = 0x02;					// Byte pair count
	data[7] = clsb; data[8] = cmsb;	// Command
	data[9] = 0x00; data[10] = 0x00;
	data[11] = 0xF7;
	AsSystemExclusive*		sysex = new AsSystemExclusive(data, 12);
	if (!sysex) return B_ERROR;
	vector<AsSystemExclusive*>	sysexVec;
	sysexVec.push_back(sysex);
	vector<BString>			valueLabels;
	fill_value_labels(valueLabels, key);
	AsCommandValue			deviceId(0, 3, 3, 0, 127);
	AsCommandValue			value(0, 9, 10, valueMin, valueMax);
	return AddSysExMultiCommand(sysexVec, initValue, key, deviceId, value, NULL, &valueLabels);
}

status_t EmuProteus2000::AddP2KMultiParamEdit(	const BString& key, uint8 clsb, uint8 cmsb,
												int32 valueMin, int32 valueMax, int32 initValue)
{
	vector<AsSystemExclusive*>	sysexVec;
	uint8					mdata[12];
	mdata[0] = 0xF0; mdata[1] = 0x18; mdata[2] = 0x0F; mdata[3] = 0x00; mdata[4] = 0x55; mdata[5] = 0x01;
	mdata[6] = 0x02; mdata[7] = 0x01; mdata[8] = 0x01; mdata[9] = 0 /* chan */; mdata[10] = 0x00; mdata[11] = 0xF7;
	AsSystemExclusive*		msysex = new AsSystemExclusive(mdata, 12);
	if (!msysex) return B_ERROR;
	uint8					data[12];
	data[0] = 0xF0; data[1] = 0x18; data[2] = 0x0F; data[3] = 0x00; data[4] = 0x55; data[5] = 0x01;
	data[6] = 0x02; data[7] = clsb; data[8] = cmsb; data[9] = 0x00; data[10] = 0x00; data[11] = 0xF7;
	AsSystemExclusive*		sysex = new AsSystemExclusive(data, 12);
	if (!sysex) return B_ERROR;

	sysexVec.push_back(msysex);
	sysexVec.push_back(sysex);
	vector<BString>			valueLabels;
	fill_value_labels(valueLabels, key);
	AsCommandValue			deviceId(0, 3, 3, 0, 127);
	AsCommandValue			value(1, 9, 10, valueMin, valueMax);
	AsCommandValue			channel(0, 9, 9, 0, 31);
	BString					chanKey(key);
	return AddSysExMultiCommand(sysexVec, initValue, chanKey, deviceId, value, &channel, &valueLabels);
}
