#include "EmuEos.h"

static const char*	SYSEX_MIX_OUTPUT		= "Mix";
static const char*	SYSEX_FX_CTRL_CHANNEL	= "FX Control";
static const char*	SYSEX_FX_BYPASS			= "FX Mode";
static const char*	SYSEX_FX_A				= "FX A";
static const char*	SYSEX_FX_A_DCY			= "FX A Decay";
static const char*	SYSEX_FX_A_HFDAMP		= "FX A HF Damp";
static const char*	SYSEX_FX_B_INTO_A		= "FX B -> A";
static const char*	SXEOS_FX_A_SEND_1		= "FX A Main";
static const char*	SXEOS_FX_A_SEND_2		= "FX A Sub 1";
static const char*	SXEOS_FX_A_SEND_3		= "FX A Sub 2";
static const char*	SXEOS_FX_A_SEND_4		= "FX A Sub 3";
static const char*	SYSEX_FX_B				= "FX B";
static const char*	SYSEX_FX_B_FEEDBACK		= "FX B Feedback";
static const char*	SYSEX_FX_B_LFO			= "FX B LFO";
static const char*	SYSEX_FX_B_DELAY		= "FX B Delay";
static const char*	SXEOS_FX_B_SEND_1		= "FX B Main";
static const char*	SXEOS_FX_B_SEND_2		= "FX B Sub 1";
static const char*	SXEOS_FX_B_SEND_3		= "FX B Sub 2";
static const char*	SXEOS_FX_B_SEND_4		= "FX B Sub 3";

/*************************************************************************
 * EMU-EOS
 *************************************************************************/
EmuEos::EmuEos(BMessage* device, const entry_ref* ref)
		: inherited(device, ref)
{
	RemoveSysExCommands();

	/* MULTIMODE (Channel specific). */
	AddMultiParamEdit(BString(SYSEX_MIX_OUTPUT),	0x7a, 0x01, -1, 3, -1);

	/* MASTER. */
	AddParamEdit(BString(SYSEX_FX_BYPASS),			0x74, 0x01, 0, 1, 1);
	AddParamEdit(BString(SYSEX_FX_CTRL_CHANNEL),	0x75, 0x01, -1, 15, -1);
	AddParamEdit(BString(SYSEX_FX_A),				0x64, 0x01, 1, 44, 14);
	AddParamEdit(BString(SYSEX_FX_A_DCY),			0x65, 0x01, 0, 90, 54);
	AddParamEdit(BString(SYSEX_FX_A_HFDAMP),		0x66, 0x01, 0, 127, 64);
	AddParamEdit(BString(SYSEX_FX_B_INTO_A),		0x67, 0x01, 0, 127, 0);
	AddParamEdit(BString(SXEOS_FX_A_SEND_1),		0x68, 0x01, 0, 100, 10);
	AddParamEdit(BString(SXEOS_FX_A_SEND_2),		0x69, 0x01, 0, 100, 20);
	AddParamEdit(BString(SXEOS_FX_A_SEND_3),		0x6a, 0x01, 0, 100, 30);
	AddParamEdit(BString(SXEOS_FX_A_SEND_4),		0x6b, 0x01, 0, 100, 40);
	AddParamEdit(BString(SYSEX_FX_B),				0x6c, 0x01, 1, 32, 1);
	AddParamEdit(BString(SYSEX_FX_B_FEEDBACK),		0x6d, 0x01, 0, 127, 0);
	AddParamEdit(BString(SYSEX_FX_B_LFO),			0x6e, 0x01, 0, 127, 3);
	AddParamEdit(BString(SYSEX_FX_B_DELAY),			0x6f, 0x01, 0, 127, 1);
	AddParamEdit(BString(SXEOS_FX_B_SEND_1),		0x70, 0x01, 0, 100, 10);
	AddParamEdit(BString(SXEOS_FX_B_SEND_2),		0x71, 0x01, 0, 100, 15);
	AddParamEdit(BString(SXEOS_FX_B_SEND_3),		0x72, 0x01, 0, 100, 30);
	AddParamEdit(BString(SXEOS_FX_B_SEND_4),		0x73, 0x01, 0, 100, 0);
}

static void fill_value_labels(vector<BString>& v, const BString& key)
{
	v.resize(0);
	if (key == SYSEX_MIX_OUTPUT) {
		v.push_back("Voice"); v.push_back("Main"); v.push_back("Sub 1"); v.push_back("Sub 2"); v.push_back("Sub 3");
	} else if (key == SYSEX_FX_CTRL_CHANNEL) {
		v.push_back("Master"); v.push_back("1"); v.push_back("2"); v.push_back("3"); v.push_back("4"); v.push_back("5"); v.push_back("6"); v.push_back("7"); v.push_back("8");
		v.push_back("9"); v.push_back("10"); v.push_back("11"); v.push_back("12"); v.push_back("13"); v.push_back("14"); v.push_back("15"); v.push_back("16");
	} else if (key == SYSEX_FX_BYPASS) {
		v.push_back("On"); v.push_back("Off");
	} else if (key == SYSEX_FX_A) {
		v.push_back("Room 1"); v.push_back("Room 2"); v.push_back("Room 3"); v.push_back("Hall 1"); v.push_back("Hall 2"); v.push_back("Plate");
		v.push_back("Delay"); v.push_back("Panning Delay"); v.push_back("Multitap 1"); v.push_back("Multitap Pan"); v.push_back("3 Tap"); v.push_back("3 Tap Pan");
		v.push_back("Soft Room"); v.push_back("Warm Room"); v.push_back("Perfect Room"); v.push_back("Tiled Room"); v.push_back("Hard Plate"); v.push_back("Warm Hall");
		v.push_back("Spacious Hall"); v.push_back("Bright Hall"); v.push_back("Bright Hall Pan"); v.push_back("Bright Plate"); v.push_back("BBall Court"); v.push_back("Gymnasium");
		v.push_back("Cavern"); v.push_back("Concert 9"); v.push_back("Concert 10 Pan"); v.push_back("Reverse Gate"); v.push_back("Gate 2"); v.push_back("Gate Pan"); v.push_back("Concert 11");
		v.push_back("Medium Concert"); v.push_back("Large Concert"); v.push_back("Lage Concert Pan"); v.push_back("Canyon"); v.push_back("DelayVerb 1"); v.push_back("DelayVerb 2"); v.push_back("DelayVerb 3");
		v.push_back("DelayVerb 4 Pan"); v.push_back("DelayVerb 5 Pan"); v.push_back("DelayVerb 6"); v.push_back("DelayVerb 7"); v.push_back("DelayVerb 8"); v.push_back("DelayVerb 9");
	} else if (key == SYSEX_FX_B) {
		v.push_back("Chorus 1"); v.push_back("Chorus 2"); v.push_back("Chorus 3"); v.push_back("Chorus 4"); v.push_back("Chorus 5"); v.push_back("Doubling"); v.push_back("Slapback"); v.push_back("Flange 1");
		v.push_back("Flange 2"); v.push_back("Flange 3"); v.push_back("Flange 4"); v.push_back("Flange 5"); v.push_back("Flange 6"); v.push_back("Flange 7"); v.push_back("Big Chorus"); v.push_back("Symphonic");
		v.push_back("Ensemble"); v.push_back("Delay"); v.push_back("Delay Stereo"); v.push_back("Delay Stereo 2"); v.push_back("Panning Delay"); v.push_back("Delay Chorus"); v.push_back("Pan Dly Chrs 1");
		v.push_back("Pan Dly Chrs 2"); v.push_back("DualTap 1/3"); v.push_back("DualTap 1/4"); v.push_back("Vibrato"); v.push_back("Distortion 1"); v.push_back("Distortion 2"); v.push_back("Distorted Flange");
		v.push_back("Distorted Chorus"); v.push_back("Distorted Double");
	}
}

status_t EmuEos::AddParamEdit(	const BString& key, uint8 clsb, uint8 cmsb,
								int32 valueMin, int32 valueMax, int32 initValue)
{
	uint8					data[13];
	data[0] = 0xF0; data[1] = 0x18; data[2] = 0x21; data[3] = 0x00;
	data[4] = 0x55;
	data[5] = 0x01;					// Parameter edit
	data[6] = 0x02;					// Byte pair count
	data[7] = clsb; data[8] = cmsb;	// Command
	data[9] = 0x00; data[10] = 0x00;
	data[11] = 0x7f;				// Checksum, 7f is ignore checksum flags
	data[12] = 0xF7;
	AsSystemExclusive*		sysex = new AsSystemExclusive(data, 13);
	if (!sysex) return B_ERROR;
	vector<AsSystemExclusive*>	sysexVec;
	sysexVec.push_back(sysex);
	vector<BString>			valueLabels;
	fill_value_labels(valueLabels, key);
	AsCommandValue			deviceId(0, 3, 3, 0, 127);
	AsCommandValue			value(0, 9, 10, valueMin, valueMax);
	return AddSysExMultiCommand(sysexVec, initValue, key, deviceId, value, NULL, &valueLabels);
}

status_t EmuEos::AddMultiParamEdit(	const BString& key, uint8 clsb, uint8 cmsb,
									int32 valueMin, int32 valueMax, int32 initValue)
{
	vector<AsSystemExclusive*>	sysexVec;
	uint8					mdata[13];
	mdata[0] = 0xF0; mdata[1] = 0x18; mdata[2] = 0x21; mdata[3] = 0x00; mdata[4] = 0x55; mdata[5] = 0x01;
	mdata[6] = 0x02; mdata[7] = 0x76; mdata[8] = 0x1; mdata[9] = 0 /* chan */; mdata[10] = 0x00; mdata[11] = 0x7f; mdata[12] = 0xF7;
	AsSystemExclusive*		msysex = new AsSystemExclusive(mdata, 13);
	if (!msysex) return B_ERROR;
	uint8					data[13];
	data[0] = 0xF0; data[1] = 0x18; data[2] = 0x21; data[3] = 0x00; data[4] = 0x55; data[5] = 0x01;
	data[6] = 0x02; data[7] = clsb; data[8] = cmsb; data[9] = 0x00; data[10] = 0x00; data[11] = 0x7f; data[12] = 0xF7;
	AsSystemExclusive*		sysex = new AsSystemExclusive(data, 13);
	if (!sysex) return B_ERROR;

	sysexVec.push_back(msysex);
	sysexVec.push_back(sysex);
	vector<BString>			valueLabels;
	fill_value_labels(valueLabels, key);
	AsCommandValue			deviceId(0, 3, 3, 0, 127);
	AsCommandValue			value(1, 9, 10, valueMin, valueMax);
	AsCommandValue			channel(0, 9, 9, 0, 31);
	return AddSysExMultiCommand(sysexVec, initValue, key, deviceId, value, &channel, &valueLabels);
}

#if 0

/***************************************************************************
 * E-MU EOS COMMANDS
 ***************************************************************************/

void AmDevice::InitEos()
{
	for (uint32 k = 0; k < mSysExCommands.size(); k++)
		delete mSysExCommands[k];
	mSysExCommands.resize(0);

	/* MULTIMODE (Channel specific). */
	AddEosMultiParamEdit(BString(SYSEX_MIX_OUTPUT),			0x7a, 0x01, -1, 3, -1);

	/* MASTER. */
	AddEosParamEdit(BString(SYSEX_FX_BYPASS),		0x74, 0x01, 0, 1, 1);
	AddEosParamEdit(BString(SYSEX_FX_CTRL_CHANNEL),	0x75, 0x01, -1, 15, -1);
	AddEosParamEdit(BString(SYSEX_FX_A),			0x64, 0x01, 1, 44, 14);
	AddEosParamEdit(BString(SYSEX_FX_A_DCY),		0x65, 0x01, 0, 90, 54);
	AddEosParamEdit(BString(SYSEX_FX_A_HFDAMP),		0x66, 0x01, 0, 127, 64);
	AddEosParamEdit(BString(SYSEX_FX_B_INTO_A),		0x67, 0x01, 0, 127, 0);
	AddEosParamEdit(BString(SXEOS_FX_A_SEND_1),		0x68, 0x01, 0, 100, 10);
	AddEosParamEdit(BString(SXEOS_FX_A_SEND_2),		0x69, 0x01, 0, 100, 20);
	AddEosParamEdit(BString(SXEOS_FX_A_SEND_3),		0x6a, 0x01, 0, 100, 30);
	AddEosParamEdit(BString(SXEOS_FX_A_SEND_4),		0x6b, 0x01, 0, 100, 40);
	AddEosParamEdit(BString(SYSEX_FX_B),			0x6c, 0x01, 1, 32, 1);
	AddEosParamEdit(BString(SYSEX_FX_B_FEEDBACK),	0x6d, 0x01, 0, 127, 0);
	AddEosParamEdit(BString(SYSEX_FX_B_LFO),		0x6e, 0x01, 0, 127, 3);
	AddEosParamEdit(BString(SYSEX_FX_B_DELAY),		0x6f, 0x01, 0, 127, 1);
	AddEosParamEdit(BString(SXEOS_FX_B_SEND_1),		0x70, 0x01, 0, 100, 10);
	AddEosParamEdit(BString(SXEOS_FX_B_SEND_2),		0x71, 0x01, 0, 100, 15);
	AddEosParamEdit(BString(SXEOS_FX_B_SEND_3),		0x72, 0x01, 0, 100, 30);
	AddEosParamEdit(BString(SXEOS_FX_B_SEND_4),		0x73, 0x01, 0, 100, 0);
}

static void fill_eos_value_labels(vector<BString>& v, const BString& key)
{
	v.resize(0);
	if (key == SYSEX_MULTI_SELECT) {
		v.push_back("1"); v.push_back("2"); v.push_back("3"); v.push_back("4"); v.push_back("5"); v.push_back("6"); v.push_back("7"); v.push_back("8");
		v.push_back("9"); v.push_back("10"); v.push_back("11"); v.push_back("12"); v.push_back("13"); v.push_back("14"); v.push_back("15"); v.push_back("16");
	} else if (key == SYSEX_MIX_OUTPUT) {
		v.push_back("Voice"); v.push_back("Main"); v.push_back("Sub 1"); v.push_back("Sub 2"); v.push_back("Sub 3");
	} else if (key == SYSEX_FX_CTRL_CHANNEL) {
		v.push_back("Master"); v.push_back("1"); v.push_back("2"); v.push_back("3"); v.push_back("4"); v.push_back("5"); v.push_back("6"); v.push_back("7"); v.push_back("8");
		v.push_back("9"); v.push_back("10"); v.push_back("11"); v.push_back("12"); v.push_back("13"); v.push_back("14"); v.push_back("15"); v.push_back("16");
	} else if (key == SYSEX_FX_BYPASS) {
		v.push_back("On"); v.push_back("Off");
	} else if (key == SYSEX_FX_A) {
		v.push_back("Room 1"); v.push_back("Room 2"); v.push_back("Room 3"); v.push_back("Hall 1"); v.push_back("Hall 2"); v.push_back("Plate");
		v.push_back("Delay"); v.push_back("Panning Delay"); v.push_back("Multitap 1"); v.push_back("Multitap Pan"); v.push_back("3 Tap"); v.push_back("3 Tap Pan");
		v.push_back("Soft Room"); v.push_back("Warm Room"); v.push_back("Perfect Room"); v.push_back("Tiled Room"); v.push_back("Hard Plate"); v.push_back("Warm Hall");
		v.push_back("Spacious Hall"); v.push_back("Bright Hall"); v.push_back("Bright Hall Pan"); v.push_back("Bright Plate"); v.push_back("BBall Court"); v.push_back("Gymnasium");
		v.push_back("Cavern"); v.push_back("Concert 9"); v.push_back("Concert 10 Pan"); v.push_back("Reverse Gate"); v.push_back("Gate 2"); v.push_back("Gate Pan"); v.push_back("Concert 11");
		v.push_back("Medium Concert"); v.push_back("Large Concert"); v.push_back("Lage Concert Pan"); v.push_back("Canyon"); v.push_back("DelayVerb 1"); v.push_back("DelayVerb 2"); v.push_back("DelayVerb 3");
		v.push_back("DelayVerb 4 Pan"); v.push_back("DelayVerb 5 Pan"); v.push_back("DelayVerb 6"); v.push_back("DelayVerb 7"); v.push_back("DelayVerb 8"); v.push_back("DelayVerb 9");
	} else if (key == SYSEX_FX_B) {
		v.push_back("Chorus 1"); v.push_back("Chorus 2"); v.push_back("Chorus 3"); v.push_back("Chorus 4"); v.push_back("Chorus 5"); v.push_back("Doubling"); v.push_back("Slapback"); v.push_back("Flange 1");
		v.push_back("Flange 2"); v.push_back("Flange 3"); v.push_back("Flange 4"); v.push_back("Flange 5"); v.push_back("Flange 6"); v.push_back("Flange 7"); v.push_back("Big Chorus"); v.push_back("Symphonic");
		v.push_back("Ensemble"); v.push_back("Delay"); v.push_back("Delay Stereo"); v.push_back("Delay Stereo 2"); v.push_back("Panning Delay"); v.push_back("Delay Chorus"); v.push_back("Pan Dly Chrs 1");
		v.push_back("Pan Dly Chrs 2"); v.push_back("DualTap 1/3"); v.push_back("DualTap 1/4"); v.push_back("Vibrato"); v.push_back("Distortion 1"); v.push_back("Distortion 2"); v.push_back("Distorted Flange");
		v.push_back("Distorted Chorus"); v.push_back("Distorted Double");
	}
}

status_t AmDevice::AddEosParamEdit(	const BString& key, uint8 clsb, uint8 cmsb,
									int32 valueMin, int32 valueMax, int32 initValue)
{
	uint8					data[13];
	data[0] = 0xF0; data[1] = 0x18; data[2] = 0x21; data[3] = 0x00;
	data[4] = 0x55;
	data[5] = 0x01;		// Parameter edit
	data[6] = 0x02;		// Byte pair count;
	data[7] = clsb; data[8] = cmsb;	// Command
	data[9] = 0x00; data[10] = 0x00;
	data[11] = 0x7f;	// Checksum, 7f is ignore checksum flags
	data[12] = 0xF7;
	AmSystemExclusive*		sysex = new AmSystemExclusive(data, 13, 0);
	if (!sysex) return B_ERROR;
	vector<AmSystemExclusive*>	sysexVec;
	sysexVec.push_back(sysex);
	vector<BString>			valueLabels;
	fill_eos_value_labels(valueLabels, key);
	_AmCommandValue			deviceId(0, 3, 3, 0, 127);
	_AmCommandValue			value(0, 9, 10, valueMin, valueMax);
	AmSysExCommand*			com = new AmSysExMultiCommand(sysexVec, initValue, key, deviceId, value, &valueLabels);
	if (!com) {
		sysex->Delete();
		return B_ERROR;
	}
	mSysExCommands.push_back(com);
	return B_OK;
}

status_t AmDevice::AddEosMultiParamEdit(const BString& key, uint8 clsb, uint8 cmsb,
										int32 valueMin, int32 valueMax, int32 initValue)
{
	for (int32 chan = 1; chan <= 16; chan++) {
		vector<AmSystemExclusive*>	sysexVec;
		uint8					mdata[13];
		mdata[0] = 0xF0; mdata[1] = 0x18; mdata[2] = 0x21; mdata[3] = 0x00; mdata[4] = 0x55; mdata[5] = 0x01;
		mdata[6] = 0x02; mdata[7] = 0x76; mdata[8] = 0x1; mdata[9] = chan; mdata[10] = 0x00; mdata[11] = 0x7f; mdata[12] = 0xF7;
		AmSystemExclusive*		msysex = new AmSystemExclusive(mdata, 13, 0);
		if (!msysex) return B_ERROR;
		uint8					data[13];
		data[0] = 0xF0; data[1] = 0x18; data[2] = 0x21; data[3] = 0x00; data[4] = 0x55; data[5] = 0x01;
		data[6] = 0x02; data[7] = clsb; data[8] = cmsb; data[9] = 0x00; data[10] = 0x00; data[11] = 0x7f; data[12] = 0xF7;
		AmSystemExclusive*		sysex = new AmSystemExclusive(data, 13, 0);
		if (!sysex) return B_ERROR;

		sysexVec.push_back(msysex);
		sysexVec.push_back(sysex);
		vector<BString>			valueLabels;
		fill_eos_value_labels(valueLabels, key);
		_AmCommandValue			deviceId(0, 3, 3, 0, 127);
		_AmCommandValue			value(1, 9, 10, valueMin, valueMax);
		BString					chanKey(key);
		chanKey << " " << chan;
//		if (chan <= 16) chanKey << " " << chan << "A";
//		else chanKey << " " << chan - 16 << "B";
		AmSysExCommand*			com = new AmSysExMultiCommand(sysexVec, initValue, chanKey, deviceId, value, &valueLabels);
		if (!com) {
			sysex->Delete();
			return B_ERROR;
		}
		mSysExCommands.push_back(com);
	}
	return B_OK;
}
#endif