/* AsWin.cpp
 */
#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <malloc.h>
#include <be/AppKit.h>
#include "AsWin.h"

static float get_font_height(const BView* view);

/*************************************************************************
 * AS-WIN
 *************************************************************************/
AsWin::AsWin()
		: inherited(BRect(100, 100, 300, 300), "AS",
					B_TITLED_WINDOW_LOOK,
					B_NORMAL_WINDOW_FEEL,
					B_NOT_ZOOMABLE | B_NOT_RESIZABLE)
{
	SetTitle("AnnotationStation");
	BView*			bg = new BView(BRect(0, 0, 0, 0), "bg", B_FOLLOW_ALL, 0);
	const char*		label = "Drop Sequitur Devices here";
	float			lw = bg->StringWidth(label);
	float			lh = get_font_height(bg);
	float			sx = 20, sy = 5;
	float			h = sy + lh + sy + 20;
	float			svT = (h - sy - lh) / 2;
	BStringView*	sv = new BStringView(BRect(sx, svT, sx + lw, svT + sy + lh), "label", label);
	ResizeTo(sx + lw + sx, h);
	bg->ResizeTo(sx + lw + sx, h);
	bg->SetViewColor(180, 180, 180);
	AddChild(bg);
	bg->AddChild(sv);
}

AsWin::~AsWin()
{
}

void AsWin::MessageReceived(BMessage* msg)
{
	if (msg->WasDropped() || msg->what == B_REFS_RECEIVED) {
		be_app->PostMessage(msg);
		return;
	}
	inherited::MessageReceived(msg);
}

bool AsWin::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return true;
}

/*************************************************************************
 * Miscellaneous functions
 *************************************************************************/

static float get_font_height(const BView* view)
{
	BFont	font;
	view->GetFont(&font);
	font_height		fh;
	font.GetHeight(&fh);
	return fh.ascent + fh.descent + fh.leading;
}
