#include <stdio.h>
#include <assert.h>
#include <malloc.h>
#include <be/StorageKit.h>
#include <be/support/String.h>
#include "AsApp.h"
#include "AsWin.h"
#include "EmuEos.h"
#include "EmuProteus2000.h"

static const char*	AsAppSig = "application/x-vnd.ARP-AnnotationStation";

/***************************************************************************
 * AS-APP
 ***************************************************************************/
AsApp::AsApp()
		: inherited(AsAppSig)
{
	ShowWin();
}

AsApp::~AsApp()
{
}

void AsApp::MessageReceived(BMessage* msg)
{
	if (msg->WasDropped() || msg->what == B_REFS_RECEIVED) {
		RefsReceived(msg);
		return;
	}
	inherited::MessageReceived(msg);
}

bool AsApp::QuitRequested(void)
{
	return true;
}

void AsApp::RefsReceived(BMessage* msg)
{
	uint32		type;
	int32		count;
	entry_ref	ref;
	BFile		file;
	BMessage	device;
	status_t	err = msg->GetInfo("refs", &type, &count);
	if (err != B_OK) return;
	if (type != B_REF_TYPE) return;
	for (long k = --count; k >= 0; k--) {
		if (msg->FindRef("refs", k, &ref) == B_OK
				&& file.SetTo(&ref, B_READ_ONLY) == B_OK
				&& device.Unflatten(&file) == B_OK) {
			file.Unset();
			DeviceReceived(&device, &ref);
			device.MakeEmpty();
		}
	}
}

void AsApp::ShowWin(void)
{
	if (!mWin.IsValid()) {
		AsWin*		win = new AsWin();
		if (win) {
			mWin = BMessenger(win);
			win->Show();
		} else PostMessage(B_QUIT_REQUESTED);
	} else {
		BHandler*	target;
		BLooper*	looper;
		if ((target = mWin.Target(&looper)) != 0)
			((BWindow*)target)->Activate(true);
	}
}

void AsApp::DeviceReceived(BMessage* device, const entry_ref* ref)
{
	BString					mfg, name;
	device->FindString("mfg", &mfg);
	device->FindString("name", &name);

	if (mfg == "E-mu") {
		if (name.IFindFirst("Proteus") != B_ERROR || name.IFindFirst("Xtreme") != B_ERROR || name.IFindFirst("Planet") != B_ERROR) {
			EmuProteus2000	p2k(device, ref);
		} else if (name.IFindFirst("EOS") != B_ERROR) {
			EmuEos			eos(device, ref);
		}
	}
			
}