/* AsAnnotater.h
 * Copyright (c)2002 by Eric Hackborn.
 * All rights reserved.
 *
 * Do anything you want with this code.
 *
 * ----------------------------------------------------------------------
 *
 * To Do
 * ~~~~~~~~~~
 *
 *	- Nothing!
 *
 * ----------------------------------------------------------------------
 *
 * Known Bugs
 * ~~~~~~~~~~
 *
 *	- None!  Ha ha!
 *
 * ----------------------------------------------------------------------
 *
 * History
 * ~~~~~~~
 * 2002.07.13				hackborn@angryredplanet.com
 * Created this file.
 */
#ifndef AS_ANNOTATER_H
#define AS_ANNOTATER_H

#include <vector.h>
#include <be/app/Message.h>
#include <be/StorageKit.h>
#include <be/support/String.h>
class AsCommandValue;
class AsSystemExclusive;

enum {
	ARP_TWOS_COMPLEMENT			= 0x00000001
};

/*************************************************************************
 * AS-ANNOTATER
 *************************************************************************/
class AsAnnotater
{
public:
	AsAnnotater(BMessage* device, const entry_ref* ref); 
	virtual ~AsAnnotater();

	/* Remove all sysex commands from the device.
	 */
	status_t			RemoveSysExCommands();

	status_t			AddSysExMultiCommand(	vector<AsSystemExclusive*>& sysex,
												int32 initValue, const BString& key,
												const AsCommandValue& deviceId,
												const AsCommandValue& value,
												const AsCommandValue* channel,
												vector<BString>* valueLabels, uint32 bitNum = 14,
												uint32 flags = ARP_TWOS_COMPLEMENT);
protected:
	status_t			mStatus;		// Subclasses can set this to something
										// other than B_OK to prevent the device
										// from being written to disk.

private:
	BMessage			mDevice;
	const entry_ref*	mRef;
	
	status_t			AddCommandValue(const char* name, const AsCommandValue& cv,
										BMessage& commandMsg);
};

/*************************************************************************
 * AS-SYSTEM-EXCLUSIVE
 * A simple wrapper around some bytes.
 *************************************************************************/
class AsSystemExclusive
{
public:
	AsSystemExclusive(const uint8* data, size_t size);
	AsSystemExclusive(const AsSystemExclusive& o);
	virtual ~AsSystemExclusive();
	
	AsSystemExclusive&		operator=(const AsSystemExclusive& o);

	uint8*				Data();
	size_t				Size();

	status_t			SetTo(const uint8* data, size_t size);

private:
	uint8*			mData;
	size_t			mSize;

	void				Free();
};

/*************************************************************************
 * AS-COMMAND-VALUE
 * Support class for determining the mutable bytes of sysex data.  This
 * object determines which piece of sysex I apply to (index), what bytes
 * in that sysex I apply to (start through end), and what the valid values
 * are for those bytes (min through max).
 *************************************************************************/
class AsCommandValue
{
public:
	AsCommandValue();
	AsCommandValue(	int32 inIndex, uint32 inStart, uint32 inEnd,
					int32 inMin, int32 inMax);
	AsCommandValue(	const AsCommandValue& o);

	AsCommandValue&			operator=(const AsCommandValue& o);
	
	int32			index;		// The command can store multiple pieces
								// of sysex data.  This specifies which
								// piece I apply to.  -1 for none.
	uint32			start, end;	// Specify the first and last byte for the value.
	int32			min, max;	// The minimum and maximum values.
};


#endif
